/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import filenet.vw.api.VWException;
import filenet.vw.base.VWAuthItem;
import filenet.vw.base.logging.Logger;
import filenet.vw.sysutils.OperatingSystem;
import java.lang.reflect.Method;

class VWFnSessShr {
    private static final Logger logger = Logger.getLogger("filenet.vw.base");
    private static final String m_className = "VWFnSessShr";
    private static boolean ONWINDOWS = OperatingSystem.isWindows();
    private static boolean NOIDM = System.getProperty("NOIDM") != null;
    private static boolean bSessShrLoaded = false;
    private static boolean bSessShrCannotBeLoaded = false;

    public static String _get_FILE_DATE() {
        return "$Date:   16 Oct 2006 11:52:34  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   lnguyen  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.2  $";
    }

    private boolean SessShrLoaded() {
        if (!bSessShrLoaded && !bSessShrCannotBeLoaded) {
            try {
                if (ONWINDOWS && !NOIDM && ClassLoader.getSystemClassLoader().loadClass("filenet.vw.idm.panagon.com.sessshr.FnSessShr") != null) {
                    bSessShrLoaded = true;
                }
            }
            catch (Throwable err) {
                logger.throwing(m_className, "static", err);
                bSessShrCannotBeLoaded = false;
                return false;
            }
        }
        return bSessShrLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized String encrypt(String name, String password) throws VWException {
        String m_method = "encrypt:" + name;
        String result = null;
        try {
            if (!this.SessShrLoaded()) return result;
            Class<?> fnsessShrCls = Class.forName("filenet.vw.idm.panagon.com.sessshr.FnSessShr");
            Class[] StringClsArray = new Class[]{Class.forName("java.lang.String")};
            Method putUserName = fnsessShrCls.getMethod("putUserName", StringClsArray);
            Method putPassword = fnsessShrCls.getMethod("putPassword", StringClsArray);
            Method getToken = fnsessShrCls.getMethod("getToken", null);
            Method Release = fnsessShrCls.getMethod("Release", null);
            Object sess = null;
            try {
                sess = fnsessShrCls.newInstance();
                if (name == null) {
                    name = "";
                }
                if (password == null) {
                    password = "";
                }
                putUserName.invoke(sess, name);
                putPassword.invoke(sess, password);
                result = (String)getToken.invoke(sess, null);
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, result);
                }
                Object var13_13 = null;
                if (sess == null) return result;
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                if (sess == null) throw throwable;
                Release.invoke(sess, null);
                throw throwable;
            }
            Release.invoke(sess, null);
            return result;
        }
        catch (Throwable ee) {
            logger.throwing(m_className, m_method, ee);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized VWAuthItem decrypt(String token) throws VWException {
        String m_method = "decrypt:" + token;
        VWAuthItem result = null;
        if (token == null || token.length() == 0) {
            throw new VWException("vw.router.VWFnSessShrInvalidToken", "Invalid token.");
        }
        try {
            if (!this.SessShrLoaded()) return result;
            Class<?> fnsessShrCls = Class.forName("filenet.vw.idm.panagon.com.sessshr.FnSessShr");
            Class[] StringClsArray = new Class[]{Class.forName("java.lang.String")};
            Method putToken = fnsessShrCls.getMethod("putToken", StringClsArray);
            Method getUserName = fnsessShrCls.getMethod("getUserName", null);
            Method getPassword = fnsessShrCls.getMethod("getPassword", null);
            Method Release = fnsessShrCls.getMethod("Release", null);
            Object sess = null;
            try {
                sess = fnsessShrCls.newInstance();
                putToken.invoke(sess, token);
                String name = (String)getUserName.invoke(sess, null);
                String pw = (String)getPassword.invoke(sess, null);
                result = new VWAuthItem(name, pw);
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, name);
                }
                Object var14_14 = null;
                if (sess == null) return result;
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                if (sess == null) throw throwable;
                Release.invoke(sess, null);
                throw throwable;
            }
            Release.invoke(sess, null);
            return result;
        }
        catch (Throwable ee) {
            logger.throwing(m_className, m_method, ee);
        }
        return result;
    }
}

